@echo off
REM MikhMon WhatsApp Gateway - Quick Install Script
REM For Windows

echo ==========================================
echo MikhMon WhatsApp Gateway Installer
echo ==========================================
echo.

REM Check if Node.js is installed
where node >nul 2>nul
if %ERRORLEVEL% NEQ 0 (
    echo X Node.js is not installed!
    echo Please install Node.js first:
    echo https://nodejs.org/
    pause
    exit /b 1
)

echo [OK] Node.js version:
node --version
echo [OK] NPM version:
npm --version
echo.

REM Check if we're in the right directory
if not exist "package.json" (
    echo X Error: package.json not found!
    echo Please run this script from whatsapp-gateway directory
    pause
    exit /b 1
)

REM Install dependencies
echo Installing dependencies...
call npm install

if %ERRORLEVEL% NEQ 0 (
    echo X Failed to install dependencies
    pause
    exit /b 1
)

echo.
echo [OK] Dependencies installed successfully!
echo.

REM Create .env file if not exists
if not exist ".env" (
    echo Creating .env file...
    copy .env.example .env
    echo [OK] .env file created
    echo.
    echo WARNING: Please update API_KEY in .env file!
    echo Also update the same API key in:
    echo   mikhmon/include/whatsapp_config.php
    echo.
) else (
    echo [INFO] .env file already exists, skipping...
    echo.
)

REM Create auth_info directory
if not exist "auth_info" (
    mkdir auth_info
    echo [OK] Created auth_info directory
)

echo.
echo ==========================================
echo [OK] Installation Complete!
echo ==========================================
echo.
echo Next steps:
echo 1. Edit .env file and set your API_KEY
echo 2. Update API key in mikhmon/include/whatsapp_config.php
echo 3. Start the gateway: npm start
echo 4. Scan QR code in admin panel
echo.
echo For production, use PM2:
echo   npm install -g pm2
echo   npm run pm2
echo.
echo Admin Panel:
echo   http://localhost/mikhmon/settings/whatsapp_gateway_admin.php
echo.
echo Documentation:
echo   See WHATSAPP_SELFHOSTED_GUIDE.md
echo.
pause
